@extends('layouts.app')

@section('title', 'Admin - Tickets')

@section('content')
<div class="admin-tickets">
    <div class="container">
        <h1>All Tickets</h1>
        
        <div class="tickets-list">
            @forelse($tickets as $ticket)
                <div class="ticket-card">
                    <div class="ticket-header">
                        <h3><a href="{{ route('admin.tickets.show', $ticket) }}">{{ $ticket->subject }}</a></h3>
                        <span class="badge badge-{{ $ticket->status }}">{{ ucfirst($ticket->status) }}</span>
                    </div>
                    <p class="ticket-description">{{ Str::limit($ticket->description, 150) }}</p>
                    <div class="ticket-meta">
                        <span>By: {{ $ticket->user->name }} ({{ $ticket->user->email }})</span>
                        <span>Priority: {{ ucfirst($ticket->priority) }}</span>
                        <span>Created: {{ $ticket->created_at->format('M d, Y H:i') }}</span>
                        @if($ticket->replies->count() > 0)
                            <span>{{ $ticket->replies->count() }} {{ Str::plural('reply', $ticket->replies->count()) }}</span>
                        @endif
                    </div>
                </div>
            @empty
                <p>No tickets found.</p>
            @endforelse
        </div>
    </div>
</div>
@endsection

